<?php
namespace Neonics;

use Composer\Script\Event;

class Composer
{
	private static $logger;

	private static function log() {
		if ( self::$logger == null )
			self::$logger = array( 'write' => function() { echo implode(" ", func_get_args() )."\n"; } );

		self::$logger->write( func_get_args() );
	}

	public static function prePackageInstall( $event ) {
		self::__event( $event );
	}

	public static function prePackageUpdate( $event ) {
		self::__event( $event );
	}

	public static function prePackageUninstall( $event ) {
		self::__event( $event );
	}
	
	private static function __event( $event ) {
		self::$logger = $event->getIO();
		self::log( "EVENT: ". $event->getName() . " type=".get_class( $event ) );
	}

	private static function get_package( Event $event )
	{
		if ( $event instanceof PackageEvent )
		{
			$op = $event->getOperation();
			switch ( $op->getJobType() )
			{
				case 'install': return $op->getPackage();
				case 'update' : return $op->getTargetPackage();
				default: self::log( "Unknown PackageEvent JobType: ".$op->getJobType() );
					return;
			}
		}
		else
		{
			self::log( "Not a package event - cannot get package info" );
			$packages = $event->getComposer()->getRepositoryManager()->getLocalRepository()->getPackages();
			//$installationManager = $event->getComposer()->getInstallationManager();
			foreach ($packages as $package) {
				$installPath = $installationManager->getInstallPath($package);
			}
		}
	}

	public static function localize_package( Event $event )
	{
		self::$logger = $event->getIO();

		// DO NOT print_r(func_get_args(),1) : 470 Mb of data!
		echo "EVENT NAME = ".$event->getName()." TYPE: " . gettype( $event ) . ' // ' . get_class( $event ). "\n";

		echo "PACKAGE: ".$event->getComposer()->getPackage()->getName();

		switch ( $event->getName() )
		{
			case 'post-package-install':
			case 'post-package-update':
		}

		$pkg = $event->getComposer()->getPackage();
		//self::get_package( $event );
		if ( ! $pkg )
			return;

		$cfg = $event->getComposer()->getConfig();
		$event->getIO()->write( "localize package executing!" );
		$event->getIO()->write( "- vendor dir  : ".print_r($cfg->get('vendor-dir'),1) );
		$event->getIO()->write( "- package name: ".print_r($pkg->getName(),1) );

		// now we copy the package:
		$vdir = $cfg->get('vendor-dir');
		$cwd = getcwd();
		$sdir = $vdir{0}=='/'
			? implode('/', array( $vdir, $pkg->getName() ) )
			: implode('/', array( $cwd, $vdir, $pkg->getName() ) );
		$ddir = implode( '/', array( $cwd, 'lib/vendor', $pkg->getName() ) );


		$x = $pkg->getExtra();

		#self::log( "PKG: ".print_r($pkg,1) );
		#self::log( "CFG: ".print_r($event->getComposer()->getConfig(),1) );
		self::log( "XTRA: ".print_r($x,1) );


		if ( $pfx = @ $x['localisation_prefix']
			|| $ns  = @ $x['localisation_namespace']
		)
		{
			self::log( "- installing copy of package to $ddir using "
				. ( $pfx ? "class prefix $pfx" : "namespace $ns" )
			);

			if ( ! is_dir( $ddir ) )
				mkdir( $ddir, 0775, true );

			self::log( "- scanning source dir $sdir");

			$todo = array( $sdir );
			self::process( $todo, $sdir, $ddir, $pfx, $ns );
		}
	}

	// funnily enough, i can say 'array &$todo, string $basedir)'
	// which gives namespace error on string; with namespace, i get
	// syntax error.
	private static function process( &$todo, $basedir, $basedest, $pfx, $ns )
	{
		while ( !empty( $todo ) )
		{
			$dh = opendir( $d = array_shift( $todo ) );
			self::log( "- dir $d" );

			while ( false !== ( $f = readdir( $dh ) ) )
			{
				if ( $f{0} == '.' )	// skip .git, ., .. etc.
					continue;

				$tmp = $d . '/' . $f;
				$tmp2= substr( $d, strlen( $basedir ) ); // handle subdir

				self::log( "- .. $f [copy $tmp -> $basedest/$tmp2/$f]" );

				if ( is_dir( $tmp ) )
					$todo[] = $tmp;
				else
					self::filtercopy( $tmp, "$basedest/$tmp2/$f", $pfx, $ns );
			}
		}

		// create a loader file

	}

	private static function filtercopy( $sfile, $dfile, $pfx, $ns )
	{
		// copy( $sfile, $dfile );
		$c = file_get_contents( $sfile );
		// TODO: use phptokens
		if ( $pfx )
			$c = preg_replace( '/^(class|interface|trait)\s+([^\s\{]+)/m', '$1 '.$pfx.'_$2 ', $c );
		if ( $ns )
			$c = "<?php namespace $ns; ?>\n$c";
		file_put_contents( $dfile, $c );
	}
}
