<?php

trait Menu
{
	/** define these fields in the class using this trait:
		private $adminpage_pfx = "FIXME-admin";

		private $menu = array(
			'slug' => array( 'Title', capability/permission, menu-slug (null or ?.php),
		);

	Menu slugs are automatically generated using the keys in the $menu array
	and should be set to null for custom pages, and, for instance, to 'edit.php?post_type=foo'
	for references to built-in admin pages.

	A handler does not need to be set; one will be automatically declared to call $this->admin_menu()
	which locates the method handling the request (see the method).

	The root menu will be defined as '{$this->adminpage_pfx}-home'.
	Wordpress will automatically add a menu item for the menu itself.
	Providing a menu item with slug 'home' (which will result in the same menu-slug)
	will override the title for this automatically added menu item.
	*/


	/**
	 * @param $have_home true: add a home page; false: use first menu item.
	 */
	function _setup_menu( $home = null )
	{
		reset( $this->menu );
		$have_home = isset( $home );
		$home = (object) $home;

		$menuslug = null;
		$menuhandler = null;
		$menuperm = null;
		if ( $have_home )
		{
				$menuslug = "$this->adminpage_pfx-home";
				$menuhandler = array( $this, 'admin_menu' );
				$menuperm = 'manage_options';
		}
		else
		{
			$first = array_values( $this->menu )[0];
			$menuslug = $first[2] ? preg_replace("/\?post_type=$/", "?post_type={$this->pt->name}", $first[2] ) : $first[2];
			$menuhandler = null;
			$menuperm = $first[1];
		}

		add_menu_page(
			_d( $home->page_title, "Plugin Home" ),
			_d( $home->menu_title, "Plugin Menu" ),
			$menuperm,										// capability
			$menuslug,										// menu-slug
			$menuhandler,									// function; null to use $menuslug as page (i.e. edit.php?...)
			null,													// icon-url
			'56'	 											  // position: 25=comments, 59=separator, 60=Appearance, 65=plugins, 55.5=woo+products
		);

		foreach ( $this->menu as $code => $data )
			add_submenu_page( $menuslug,			// parent menu slug
				"TR ".$data[0],									// page title
				$data[0],												// menu title
				$data[1],												// capability
				$data[2]?preg_replace("/\?post_type=$/", "?post_type={$this->pt->name}", $data[2]):"$this->adminpage_pfx-$code",		// menu slug
				$data[2]?'':array( $this, 'admin_menu' )
			);

		// set menu icon
		add_action( 'admin_head', function() {
			echo <<<HTML
				<style type='text/css' data-name='WOO TR'>
					#adminmenu #toplevel_page_edit-post_type-{$this->pt->name} .wp-menu-image:before {
						content: '\\f179';
					}
					#adminmenu #toplevel_page_$this->adminpage_pfx-home .wp-menu-image:before {
						content: '\\f179';
					}
				</style>
HTML;
		} );
	}


	/**
	 * Main menu dispatcher.
	 *
	 * This method will, for a menu line declared as    'foo-bar' => array( 'Foo', ....),
	 * first attempt to locate method _admin_menu_foo_bar,
	 * and second to include 'inc/foo-bar.php', which is expected to
	 * either provide the class name in $CLASS and/or create an object
	 * and store it in $INSTANCE. When no $INSTANCE is set, one will be
	 * constructed using $CLASS, and it's page() method called.
	 */
	public function admin_menu( $title = "Admin Menu" ) {
		global $plugin_page; # wp
		echo "<div class='wrap'><h1>". $title ."</h1>";

		$p = substr( $plugin_page, strlen( "$this->adminpage_pfx-" ) );
		$method = "_admin_menu_".str_replace( '-','_', $p );
		$file = dirname( __FILE__ )."/inc/$p.php";

		if ( method_exists( get_class( $this ), $method ) )
			$this->$method();
		else if ( file_exists( $file ) )
		{
			$CLASS = null;
			$INSTANCE = null;
			$RET = include_once( $file );
			if ( $INSTANCE == null )
				if ( $CLASS !== null )
					$INSTANCE = new $CLASS( $this );
			if ( $INSTANCE != null )
				$INSTANCE->page();
			else
				echo "<div class='error'>"._x("No class/instance!", "warning", "wp-woo-psr")."</div>";
		}
		else
		echo "<div class='error'>".sprintf( _x("no method %s; no include file %s", 'warning', 'wp-woo-psr'), $method, $file )."</div>";

		echo "</div>";
	}
}
