<?php
/**
 * Simple Wordpress Notice wrapper.
 *
 * Will cache AJAX and POST notices:
 * Notices issued during AJAX calls of the plugin will either corrupt the AJAX response,
 * or go unnoticed.
 * Issuing notices during a POST will not work, due to the POST-GET mechanism employed
 * to prevent sumitting the same form twice.
 */
trait Notices
{
	private $use_session = false;
	private $notices = array();

	private function _notice_init()
	{
		$this->use_session = (defined('DOING_AJAX') && DOING_AJAX) || $_SERVER['REQUEST_METHOD']=='POST';// || !empty( $_REQUEST['action'] );

		add_action( 'admin_notices',  array( $this, '_admin_notices') );
		$foo = $this;
		add_filter( 'wp_redirect_status', function($httpcode) use ($foo) { $this->use_session = true; } ); # $this->notice( "redirect intercept ($httpcode)" );} );

		// we need the session:
		// a) to store messages if we're in POST-GET or AJAX mode
		// b) to retrieve messages when we're not
		if ( ! session_id() )
			session_start();


		#if ( $this->use_session )
		#{
		# if ( ! isset( $_SESSION[$sessfield] ) )
		# 	$_SESSION[$sessfield] = array();
		#	$this->notices = $_SESSION[$sessfield]; // copy
		#}
		$sessfield = 'notices_'.get_class( $this );

		add_action('shutdown', function() use($sessfield) {
			$_SESSION[$sessfield] = $this->notices;
		} );

		if ( ! isset( $this->notices['notices']) )
			$this->notices['notices'] = array('updated'=>array(),'error'=>array());
		$this->notices['counter'] = ! isset( $_SESSION[$sessfield]['counter']) ? 0 : $_SESSION[$sessfield]['counter']+1;
		if ( defined('DOING_AJAX') && DOING_AJAX )
			$this->notices['ajax-counter'] = ! isset( $_SESSION[$sessfield]['ajax-counter'] ) ? 0 : $_SESSION[$sessfield]['ajax-counter'] + 1;

		#$this->notice("use_session: " . ($this->use_session?"true":"false" )  );
		#$this->notice("(counter: ". $this->notices['counter'].")");
	}

	function _admin_notices()
	{
		$sessfield = 'notices_'.get_class( $this );

		#$this->notice( "DEBUG rendering admin notices for $sessfield Use session: ".( $this->use_session ?"yes":"no" )."; Session:\n<pre>" . print_r($_SESSION,1) . "</pre>\n" );
		#$this->notice( "DEBUG rendering admin notices for $sessfield Use session: ".( $this->use_session ?"yes":"no" )."; Session:\n<pre>" . print_r($_SESSION[$sessfield]['notices'],1) . "</pre>\n" );

		if (!$this->use_session) # (!defined('DOING_AJAX') ||! DOING_AJAX)
		{
			if ( isset( $_SESSION[$sessfield] ) ) // $this->use_session ) // this works; _notice_init stuff doesn't
			{
				if ( !empty( $_SESSION[$sessfield]['notices']['updated'] )
					|| !empty( $_SESSION[$sessfield]['notices']['error'] )
				)
					$this->notice( "AJAX/POST notices follow: ".
						"<style type='text/css'>
							div.cust-notice { border-left: 4px solid blue; margin: 1em; padding: .5em; background-color: #eef; }
						</style>".
						#htmlentities(
						$this->_render_notices( $_SESSION[$sessfield]['notices'], 'cust-notice' )
						#)
					);
				#else echo $this->notice( 'session notices empty' );
			}

			echo $this->_render_notices( $this->notices['notices'] );
			unset( $this->notices['notices'] );
		}
		else
		{
			$this->notice( 'storing notices in session');
			#if ( ! empty( $this->notices ) )
			$_SESSION[$sessfield] = array_merge(
			$_SESSION[$sessfield], $this->notices
			);
		}
	}

	function _render_notices( $list, $cssclassoverride = null ) {
		$ret = "";
		foreach ( $list as $type => $notices )
			foreach ( $notices as $i=>$v )
				if ( $cssclassoverride == null )
					$ret .= "<div class='$type'><b>".get_class($this)." Notice</b>: $v</div>\n";
				else
					$ret .= "<div class='$cssclassoverride'><b>[$type] ".get_class($this)." Notice</b>: $v</div>\n";
		return $ret;
	}

	private function _n( $type, $msg )
	{
		file_put_contents( "/tmp/wp-notices.log", "[$type] $msg\n", FILE_APPEND );
		return $this->notices['notices'][ $type ][] = $msg;
	}

	function notice( $msg ) {
		return $this->_n( 'updated', $msg );
	}

	function error( $msg ) {
		return $this->_n( 'error', $msg );
	}
}
