<?php
trait Scripts
{
	private $scripts_to_register;

	private $min = ''; // set to '.min.' to enable minified scripts

	// unfortunately traits do not have a constructor, it seems
	public function _scripts_init()
	{
		add_action( 'wp_enqueue_scripts', function()
		{
			echo "<h1>trait enqueue scripts</h1>";
			// doesn't seem to be called.
		} );
	}

	public function add_script( $script, $deps = array() )
	{
		wp_register_script( __FILE__.$script, plugins_url( "assets/$script" ,dirname(__FILE__)) . $this->min . '.js', $deps );
		wp_enqueue_script( __FILE__.$script );
	}

	public function add_style( $script, $deps = array() )
	{
		wp_register_style( __FILE__.$script, plugins_url( "assets/$script" ,dirname(__FILE__)) . $this->min . '.css', $deps );
		wp_enqueue_style( __FILE__.$script );
	}


	public function add_module( $module, $deps = array(), $scriptext="" )
	{
		wp_register_script( __FILE__.$module, plugins_url( "assets/$module/$module{$scriptext}" ,dirname(__FILE__)) . $this->min . '.js', $deps );
		wp_enqueue_script( __FILE__.$module );
		wp_register_style( __FILE__.$module, plugins_url( "assets/$module/$module" ,dirname(__FILE__)) . $this->min . '.css' );
		wp_enqueue_style( __FILE__.$module );
	}


}
