<?php

abstract class MetaBox
{
	static $metaboxes = array();

	protected $posttype;
	protected $plugin;

	var $title;
	var $location;
	var $default;

	public function __construct( $posttype, $title, $location = 'normal', $priority = 'default' )
	{
		$this->plugin = $posttype->plugin;
		$this->posttype = $posttype;
		$this->title = $title;
		$this->location = $location;
		$this->priority = $priority;

		// won't trigger when called from within 'add_meta_boxes', hence here.
		//add_action( "save_post_$posttype->name", function( $post_id, $post ) {

		// autosave doesn't call save_post_POSTTYPE but does call save_post.
		add_action( "save_post", function( $post_id, $post ) {
		#	$this->plugin->notice(get_class($this)."::save!".print_r(func_get_args(),true));
			#echo "<code><b>".__FILE__."</b>save_post</code>";
			$this->save( $post_id, $post );
		}, 10, 2 );

		// delayed creation of metabox.
		if ( empty ( self::$metaboxes ) )
			add_action( 'add_meta_boxes', function($post_type, $post) {
				foreach ( self::$metaboxes as $i => $m )
					#function add_meta_box( $id, $title, $callback, $screen = null, $context = 'normal'|'advanced'|'side', $priority = 'high'|'core'|'default'|'low', $callback_args = null )
					add_meta_box( get_class($m), $m->title, array( $m, 'render' ), $m->posttype->name, $m->location, $m->priority );
			},10,2 );

		self::$metaboxes[] = $this;
	}

	abstract function render( $post, $metabox );
	function save( $post_id, $post )
	{
		$this->plugin->pt->save( $post_id, $post );
	}
}
