<?php
/*
Plugin Name: Neonics Plugin
Plugin URI: http://repo.neonics.com/wp-plugins/neonics/
Description: Some WP improvements
Version: 0.1-SNAPSHOT
Text Domain: neonics
Author: Neonics
Author URI: http://neonics.com

@author Kenney Westerhof <kenney@neonics.com>
*/
/* Changelog:
0.1:
	Initial version.
*/

!defined( 'ABSPATH' ) and header('HTTP/1.0 404') || exit;

if ( !class_exists( 'NNX_Plugin' ) ) :

// woocommerce detection:
$_psr_have_wc = in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );

// traits
$base = __DIR__ . '/vendor/neonics/wp-plugin-base';
require_once("$base/util.php");
require_once("$base/options.php");
require_once("$base/menu.php");	// admin, but can't conditionally use trait..
require_once("$base/notices.php");
require_once("$base/scripts.php");
require_once("$base/posttype.php");
#include_once("$base/shortcodes.php");
if ( is_admin() ) :
require_once("$base/metabox.php");
endif;


class NNX_Plugin
{
	use Menu;
	use Notices;
	use Scripts;

	public $options;

	var $pt;

	public function __construct()
	{
		$this->options = new PluginOptions( $this );
		add_action( 'init', function() {
			#$this->pt = new PostType( $this, 'woo-psr-query' ); // registers menus - do after 

			// we'll also add a 'Edit Query' button to the WP Admin Bar (aka Toolbar)
			add_action( 'admin_bar_menu', function($wp_admin_bar) {
				$wp_admin_bar->add_node( array(
					'id'		=> 'neonics-plugin-menu',
					'title'	=> _x( 'Neonics', 'admin-bar', 'neonics' ),
					'href'	=> '#'#admin_url( 'post.php?action=edit&post_type='.$this->pt->name."&post=".$wp_the_query->query_vars['TR_QUERY']->ID )
				) );
			}, 999 );
		});

		add_action( 'plugins_loaded', function() {
			// we might wanna skip this for frontend if we only have admin i18n
			load_plugin_textdomain( 'neonics', false, basename(dirname(__FILE__))."/i18n" );
		} );


		if ( is_admin() )
		{
			$this->_notice_init();
			$this->_scripts_init();

			add_action( 'admin_notices',	array( $this, '_admin_notices') );
			add_action( 'admin_menu',			array( $this, '_admin_menu_init' ) );
			add_action( 'admin_init',			array( $this, '_admin_init' ) );
		}
	}

	function _admin_init() {
		#$this->pt->admin_init();	# runs after init, see below for '$pt'
	}

	/////////////////////////////////
	///// admin menu
	private $menu;
	function _admin_menu_init()
	{
		$this->menu = array(
		// slug			=> array( Title,    														capability,				menu slug/page )
			'home'		=> array( _x('Home',			'menu','neonics'), 'manage_options',	null ),
			// can't use $this here - inc/menu.php appends post type
			// XXX can.
	#		'edit'		=> array( _x('Queries',		'menu','neonics'), 'edit_posts',			"edit.php?post_type=" ),
	#		'add'			=> array( _x('Add Query',	'menu','neonics'),	'edit_posts',			'post-new.php?post_type='),
			'options' => array( _x('Settings',	'menu','neonics'),	'manage_options',	null ),
		);
		$this->_setup_menu();
	}

	private $adminpage_pfx = "neonics";

	private function _admin_menu_home() {
		$base = plugin_dir_url(__FILE__);
		echo "<h1>Home</h1><code>todo</code>";
	}

	private function _admin_menu_options() {
		$this->options->page();
	}
}
endif;

function NNX() {
	static $instance = null;
	return $instance == null ? $instance = new NNX_Plugin() : $instance;
}

NNX();
?>
