<?php

class PostType
{
	var $plugin;
	var $name;

	public function __construct( $plugin, $name )
	{
		$this->plugin = $plugin;
		$this->name = $name;
	}

}

class PSRQueryPostType extends PostType
{
	private $option_name = 'wp-woo-psr_permalinks';
	private $query_base;
	static $query_base2;

	var $nonce_key;

	/** called in action 'init' */
	public function __construct( $plugin, $name )
	{
		parent::__construct( $plugin, $name );
		$this->nonce_key = plugin_basename( __FILE__ );
		$permalinks = get_option( $this->option_name );
		self::$query_base2 =
		$this->query_base = isset( $permalinks['query_base'] ) ? $permalinks['query_base'] : $this->name;

		$this->register();
		$this->init_permalinks();
	}

	# called from plugin.php admin_init hook
	public function admin_init()
	{
		foreach ( explode(" ", "query-attributes productcount" ) as $box )
			require_once( "metabox-$box.php" );

		$this->init_permalink_settings();
		$this->init_editing();
		$this->init_admin_menu();
	}

	/** called in action 'init' */
	private function register()
	{

		# https://codex.wordpress.org/Function_Reference/register_post_type
		$r = register_post_type( $this->name, array(
			#'label' => "TR Queries",# (plural)
			'labels' => array(
				'name'					=> __("TR Queries",				'wp-woo-psr'),// 'name' - general name for the post type, usually plural. The same as, and overridden by $post_type_object->label
				'singular_name'	=> __("TR Query",					'wp-woo-psr'),// 'singular_name' - name for one object of this post type. Defaults to value of 'name'.
																																// 'menu_name' - the menu name text. This string is the name to give menu items. Defaults to value of 'name'.
																																// 'name_admin_bar' - name given for the "Add New" dropdown on admin bar. Defaults to 'singular_name' if it exists, 'name' otherwise.
																																// 'all_items' - the all items text used in the menu. Default is the value of 'name'.
				'add_new'				=> __('Add New TR Query',	'wp-woo-psr'),// 'add_new' - the add new text. The default is "Add New" for both hierarchical and non-hierarchical post types.
				'add_new_item'	=> __('Add New Tailored Results Query',
																									'wp-woo-psr'),// 'add_new_item' - the add new item text. Default is Add New Post/Add New Page
				'edit_item'			=> __('Edit TR Query',		'wp-woo-psr'),// 'edit_item' - the edit item text. In the UI, this label is used as the main header on the post's editing panel.
				'new_item'			=> __('New TR Query',			'wp-woo-psr'),// 'new_item' - the new item text. Default is "New Post" for non-hierarchical and "New Page" for hierarchical post types.
				'view_item'			=> __('View TR Query',		'wp-woo-psr'),// 'view_item' - the view item text. Default is View Post/View Page
																																// 'search_items' - the search items text. Default is Search Posts/Search Pages
																																// 'not_found' - the not found text. Default is No posts found/No pages found
																																// 'not_found_in_trash' - the not found in trash text. Default is No posts found in Trash/No pages found in Trash.
				'parent_item_colon'=>__('Parent Query',		'wp-woo-psr'),// 'parent_item_colon' - the parent text. This string is used only in hierarchical post types. Default is "Parent Page". 
			),
			# description
			'public' => true, #| 'false'
			'exclude_from_search' => false,#! public
			'publicly_queryable'  => true,#public
			'show_ui' => true,	# show admin edit page for this post type
			'show_in_nav_menus' => true,
			# show_in_menu => show_ui
			'show_in_menu' => false,
			'show_in_admin_bar'=> true, # value of show_in_menu (NOT inherited from show_ui!)
			#'menu_position' => int,
			#'menu_icon' => '',//generates 'menu-icon-$posttype' css class
			'menu_icon' => 'dashicons-search',
			# capability_type => 
			# capabilities => array
			'hierarchical' => true, # for parent pages

			# edit.php/post.php supported fields:
			#'supports'=>array('title','page-attributes' ),
			'supports'=>array('title','page-attributes' ),
			#'supports' => array( 'title', 'editor','comments','trackbacks','revisions','author', 'excerpt', 'custom-fields', 'thumbnail','page-attributes'),

			# supports => title, editor, author, excerpt, trackbacks, ....
			// this is disabled!
			'_xx_register_meta_box_cb' => function( $post )
			{
				echo '<code>PostType:in register_meta_box_cb!</code>';
				add_meta_box( "psr-metabox", "TR Product Search Box", function( $ignored, $post_type ) {
					$post_type = array(
						'args' => (object) array(
							'name' => 'page',#'woo-psr-query',  # post type
							# '_default_query'=>
						)
					);
					wp_nav_menu_item_post_type_meta_box( /*$object_unused*/null, $post_type );
				}, 'nav-menus', 'side' );
				#add_action( 'save_post', array($this, 'save') );
			},#add_meta_box(); remove_meta_box(); }
			# taxonomies =>	# idem as register_taxonomy_for_object_type

			'taxonomies' => array( 'category', 'product_cat', 'product_tag' ),#, 'product_attributes', 'pa_lange', 'marke', 'typ' ),


			'has_archive' => false,
			# permalink_epmask
			# rewrite => false | array(
			#    'slug' => string  (post_type)
			#    'with_front' => bool
			#    'feeds'=>
			#    'pages'=>
			#    'ep_mask'=>
			# )
			'rewrite'=> false,
				#false,  # /woo-psr-query/pandora/pandora-beads
				/*
				array(
					'slug'=> $this->query_base,
					'with_front' => 'false',
					'pages'=>array('bar'),
				),
				/*
				*/
			'query_var'=>true,	# needed when rewrite = false; has no effect when 'publicallu_queryable' is false; defaults to true; string instead of true: the query var name.
			# can_export
			# _builtin
			# _edit_link
		) );
#			echo "<pre><b>reg: </b>".print_r($r,true)."</pre>";
	}


	private function init_permalinks()
	{
		add_rewrite_tag( '%pagename%', '([^&/]*)', 'pagename=' );
		add_rewrite_tag( '%woo-psr-query%', '([^&/]*)', 'woo-psr-query=' );

		// we add our rule directly, rather than using a permastruct for several reasons:
		// 1) wp splits the permastruct and omits declaring query vars for absent path parts
		//    so we have no way of detecting the query url using the wp query
		// 2) it adds attachments/ (due to the type being hierarchical) and other
		//    endpoints that cannot be suppressed, thus slowing down page matching.
		// 3) we combine the paging rule into this one for efficiency.
		if (true)
		add_rewrite_rule(
			'^'.$this->query_base.'/([^/\?\&]*)(/([^/\?]*))?(/page/([0-9]+)/?)?$',
			'index.php?pagename=$matches[1]&woo-psr-query=$matches[3]&paged=$matches[5]','top');

		else
		{
			/*
			// this will override the 'rewrite' post type config above
			global $wp_rewrite;
			$wp_rewrite->add_permastruct( 'woo-psr-query',  // post type name
				"/{$this->query_base}/%pagename%/%woo-psr-query%",
				array(
					'with_front' => false, 	// with-front: true = prepend blog permalink
					'ep_mask' => EP_PERMALINK | EP_PAGES
					'feed' => true,
					'endpoints' => false,
					'walk_dirs' => false
				)
				);
			*/
		}
		// XXX TODO only do this on plugin (de)activation
		flush_rewrite_rules();
		#echo "<code>written rewrite rules</code>";

		/**
		 * psr-query can have a parent, which is a psr-query,
		 * and it can have a _psr_resultpage meta, referencing a page.
		 *
		 * The permalink format is /catalog/resultpage/query 
		 *
		 * IF the current query has a _psr_resultpage set, that resultpage is used,
		 * otherwise, parent queries are traversed to find a resultpage.
		 *
		 */
		add_filter( 'post_type_link', function($permalink,$post_id,$leavename) {
			# NOTE: post_id may be int or WP_Post object!
			$post;
			if ( is_a( $post_id, 'WP_Post' ) )
			{
				$post = $post_id;
				$post_id = $post->ID;
			}
			else
			{
				$post = get_post( $post_id );
			}

			if ( $post->post_type == $this->name )
			{
				do
				{
					$resultpage_id = get_post_meta( $post_id, '_psr_resultpage', true );
					if ( $resultpage_id )
					{
						$resultpage = get_post( $resultpage_id );
						$permalink = '/'.$this->query_base .'/'. $resultpage->post_name . '/' . (
							$leavename
							? '%postname%'
							: $post->post_name
						);
					}
					else
					{
						$post_id = $post->post_parent;
						if ( $post_id )
						$post = get_post( $post_id );
						#else $this->plugin->notice("<code>no parent for $post->ID (pid=$post_id)</code>");
						# XXX maybe add check for proper post type
					}

				} while ( ! $resultpage_id && $post_id );
			}
			return $permalink;
		}, 10, 3 );

		// hide permalink edit box if there is no resultpage
		add_filter( 'get_sample_permalink_html', function($return, $id, $title, $slug) {
			// slug is still original, but is already replaced in $return html layout
			return
				get_post( $id )->post_type == $this->name
				? ( get_post_meta( $id, '_psr_resultpage', true ) ? $return : $return ) // WAS: << ? $return : "">>
				: $return;
		}, 10, 4 );

		add_filter( 'wp_unique_post_slug', function($slug, $post_ID, $post_status, $post_type, $post_parent, $original_slug )
		{
			if ( $post_type != $this->name
				|| $post_parent		// has parent - let hierarchy solve it
			)
				return $slug;

			// check if the combination resultpage + query is unique:
			global $wpdb;
			$count = $wpdb->get_var( $wpdb->prepare(
				"
				SELECT count(*) FROM $wpdb->posts
				LEFT JOIN $wpdb->postmeta ON meta_key='_psr_resultpage' AND ID=post_id
				WHERE post_type=%s
				AND   post_name=%s
				",
				$this->name, $slug )
			);
			#echo "<code><b>COUNT</b>: $count<b> $post_parent</b></code>";

			return $count === 0 ? $original_slug : $slug;
		},
		20, 6 );

	}



	////////////////////////////////////////////////////////
	//// Administrator functionality
	////////////////////////////////////////////////////////

	private function init_admin_menu()
	{
		add_action( 'admin_menu', function()
		{
#			echo "<code>reg post type admin menu (screen=".get_current_screen().")</code>";

			#add_posts_page(
			#add_object_page(
			# XXX TODO: i18n; doesn't seem to be used!
			$r=add_submenu_page( 'psr-admin-home',#'edit.php?post_type=page',
				'TR Query Browser', 'TR Queries', 'manage_woocommerce'/*cap*/, 'psr-unique-menu-slug'
				, function() { echo "<code>HANDLING!! ".print_r(func_get_args(),true)."</code>"; 
				#		wp_redirect(admin_url('edit.php?post_type='.$this->name)); 
        #    exit;
				} 
				);
			global $submenu;
#echo "<pre><b>menu: </b>".print_r($submenu,true)."</pre>";
			# fix link
			foreach ( $submenu['psr-admin-home'] as $i=>$m )
				if ( $m[2] == 'psr-unique-menu-slug' )
					$submenu['psr-admin-home'][$i][2] = 'edit.php?post_type='.$this->name;
#echo "<pre><b>menu: </b>".print_r($submenu['psr-admin-home'],true)."</pre>";

			#add_posts_page(
			#add_object_page(
#			add_submenu_page( 'edit.php?post_type=my-cust-post-type',#.$this->name,
#				'TR Query Browser', 'TR Queries 2', 'edit_posts'/*cap*/, 'psr-unique-menu-slug'
#				);


#      add_submenu_page( 'edit.php?post_type='.$this->name, __( 'Queries', 'woo-psr' ), __( 'Queries', 'woo-psr' ), 'edit_posts', 'psr-queries', array( $this, 'queries_page' ) );
#			add_submenu_page( 'woocommerce', __( 'Weports', 'woocommerce' ),  __( 'Weports', 'woocommerce' ) , 'view_woocommerce_reports', 'wc-reports', array( $this, 'reports_page' ) );
#			add_submenu_page( 'edit.php?post_type='.$this->name,
#				'TR Query Browser', 'TR Queries', 'edit_posts'/*cap*/, 'edit.php', function() {
#				echo "<code>HANDLING!! ".print_r(func_get_args(),true)."</code>";
#			} );


		} );
	}

	private function init_editing()
	{

		#$column_headers[ $screen->id ] = apply_filters( 'manage_' . $screen->id . '_columns', array() );

		add_filter( #'manage_edit_columns',
	#		'manage_'.$this->name.'_posts_columns',
			'manage_edit-'.$this->name.'_columns',
			function($in){
			#$this->plugin->notice( "<code><b>FILTER:</b>manage_.._posts_custom_column--<pre>".print_r($in,true)."</pre></code>" );
			return array_merge($in, array('resultpage'=>__('Result Page', 'wp-woo-psr'), 'slug' => __('Slug', 'wp-woo-psr')));

			# TODO doesn't work well with indexed arrays
			# PLAN: inject these fields after 'title' etc..
#			return array_splice($in, array_search( 'date', $in ) -1, 0, array('resultpage'=>__('Result Page'), 'slug' => __('Slug')));
		}, 10, 1);


		add_action( #'manage_edit_columns',
			'manage_'.$this->name.'_posts_custom_column',
			function($colname, $post_id){
			#echo "<code><b>ACTION:</b>manage_.._posts_columns; name=$colname post_id=$post_id</code>";
				switch ( $colname )
				{
					case 'resultpage':
					{
						$pm = get_post_meta( $post_id, '_psr_resultpage', true );
						echo $pm .($pm?" (".get_post_field( 'post_name', $pm ) .")": "" );
						break;
					}

					case 'slug':
					{
						echo get_post_field( 'post_name', $post_id );
						break;
					}
				}
		}, 10, 2);


		add_action( 'quick_edit_custom_box', function($column_name, $post_type) {
			echo "<code>QE ".print_r(func_get_args(),true)."</code>";
			if ( $this->name == $post_type )
			;
		},10,2 );

		add_action( 'bulk_edit_custom_box', function($column_name, $post_type) {
			if ( $post_type != $this->name || $column_name != 'resultpage' )
				return;

			$dropdown_args = apply_filters( 'page_attributes_dropdown_pages_args',
				array(
					'post_type'        => 'page',
					#'exclude_tree'     => $post->ID,
					#'selected'         => $resultpage_id,
					'name'             => '_psr_resultpage',
					'show_option_no_change' => '-- '.__('no change','wp-woo-psr').' --',
					'sort_column'      => 'menu_order, post_title',
					'echo'             => 0,
				)
			 , null
			);
			$pages = wp_dropdown_pages( $dropdown_args );

			?>
				<fieldset class="inline-edit-col-left"> <!-- will be right -->
					<!-- add psr nonce: checked in save_post_.. -->
					<input type='hidden' name='psr_meta_nonce' value='<?php echo wp_create_nonce($this->nonce_key);?>'/>
					<input type='hidden' name='psr_meta_nonce_file' value='<?php echo plugin_basename(__FILE__);?>'/>
					<div class="inline-edit-col">
						<label>
							<span class="title inline-edit-resultpage alignleft" for="eventdate">Resultpage</span>
						</label>
						<?php echo $pages; ?>
					</div>
				</fieldset>
			<?php

		}, 10, 2 );

		# called from wp-admin/edit-form-advanced.php, after the builtin metaboxes on the post.php edit page
	#	if ( false ) # this works:
		new ProductCountMetaBox( $this );
		new QueryAttributesMetaBox( $this );

/*
		add_action( 'save_post', function($postId, $post ) {
			echo "<code><b>SAVE POST $postId</b></code>";
		},10,2 );
		add_action( 'pre_post_update', function($post_or_postId ) {
			echo "<code><b>PRE POST UPDATE</b></code>";
		},10,1 );
		add_action( 'post_updated', function($post_or_postId ) {
			$this->plugin->notice( "<code><b>POST UPDATED</b></code>"
			."<code>_psr_resultpage: ".$_POST['_psr_resultpage']."</code>"
			);
		},10,1 );
		add_action( "save_post_$this->name", function( $post_id, $post ) {
			$this->plugin->notice( "orig save post!");
		}, 10, 2 );
*/
	}

/////////////////////////////

/////////////////////////////


	public static function print_tree( $tree, $rows, $indent="", $callback = null)
	{
		foreach ( $tree as $row )
		{
			$l = sprintf( "%-60s %s\n",
				"$indent o [$row->ID] $row->post_name ",
				"<a href='/" . self::$query_base2."/".$row->resultpage."/".$row->post_name."'>".
				$row->resultpage . ( $row->rp_override ? "*":"" )
				."</a>"
			);

			$l = preg_replace( "/\[(\d+)]/", "<a href='".admin_url( 'post.php' )."?post=$1&action=edit'>[$1]</a>", $l );

			print $l;

			if( isset( $row->children ) )
			self::print_tree( $row->children, $rows, "$indent  " );
		}
	}

	/**
	 * Fast method to construct a tree from a flat parent-child list without recursion.
	 *
	 * @returns array( $rows, $tree, $descendants )
	 */
	public function make_tree()
	{
		$DEBUG = false;

		global $wpdb;
		$all = $wpdb->get_results( "
			SELECT p.ID ID, p.post_parent post_parent, p.post_name post_name
			, po.meta_value rp_override
			, rp.post_name resultpage
			FROM $wpdb->posts p
			LEFT JOIN $wpdb->postmeta pm ON pm.post_id=id AND pm.meta_key='_psr_resultpage'
			LEFT JOIN $wpdb->postmeta po ON po.post_id=id AND po.meta_key='_psr_override_resultpage'
			LEFT JOIN $wpdb->posts rp ON pm.meta_value=rp.id
			WHERE p.post_type='".$this->name."'
		" );
		//   OR(p.post_type='revision' AND p.post_parent IN (SELECT ID from $wpdb->posts WHERE post_type='".$this->name."'))

		// make keyed hash using object pointers
		$rows = array();
		foreach ( $all as $row )
			$rows[ $row->ID ] = $row;

		$roots = array();
		$descendants = array();
		$rp_descendants = array(); # id => descendants who inherit resultpage
		foreach ( $all as $row )
			if ( $row->post_parent )
			{
				$rows[ $row->post_parent ]->children[] = $row;

				// climb tree and register row as descendant
				for( $p=$row; $p->post_parent; $p = $rows[ $p->post_parent ] )
				{
					$rows[ $p->post_parent ]->descendants[] = $row;
					$descendants[ $p->post_parent ][] = $row->ID;

					if ( ! $row->rp_override )
						$rp_descendants[ $p->post_parent ][] = $row->ID;
				}
			}
			else
				$roots[] = $row;

$DEBUG=1;
		if ( $DEBUG )
		{
			$n = function( $a ) use ($rows) { return isset($rows[$a])?"[$a] ".$rows[$a]->post_name .($rows[$a]->rp_override?"*":"") : $a; };
			$t = function( $a ) use ($n) { return array_map( $n, $a ); };
			ob_start();
			echo "<b>tree:</b>\n";
			self::print_tree( $roots, $rows );
			$this->plugin->notice( "<pre>".ob_get_clean()."</pre>" );

			// print list of all descendants for each node

			ob_start();
			foreach ( $descendants as $parent => $ch )
				print( "\n<b>{$n($parent)}</b> (".count($ch).")\n  ".implode("\n  ", $t( $ch ) ) );
			$this->plugin->notice( "<pre>".ob_get_clean()."</pre>" );


			ob_start();
			foreach ( $rp_descendants as $parent => $ch )
				print( "\n<b>{$n($parent)}</b> (".count($ch).")\n  ".implode("\n  ", $t( $ch ) ) );
			$this->plugin->notice( "<pre>".ob_get_clean()."</pre>" );
		}

		return array( $rows, $roots, $descendants, $rp_descendants );
	}


	/**
	 * Fast method to construct a tree from a flat parent-child list without recursion.
	 * Extracts and returns all descendants from the given $post_id.
	 */
	public function get_descendants( $post_id = null )
	{
		return $this->make_tree()[2][$post_id];
	}


	private function init_permalink_settings()
	{
		// alter the Permalink Settings page
		add_settings_section( 'wp-woo-psr-permalink', "<a name='psr'></a>".__('TR Query Permalink Settings','wp-woo-psr'), function() {
			echo wpautop( __("Define the root-level slug for TR Query detection.",'wp-woo-psr'));
		}, 'permalink' );
		add_settings_field( 'wp-woo-psr-query-slug', __('TR Query Permalink Base','wp-woo-psr'), function() {
		  $permalinks = get_option( $this->option_name );
			?>
				<input name="wp_woo_psr_query_slug" type="text" class="regular-text code"
					value="<?php if ( isset( $permalinks['query_base'] ) ) echo esc_attr( $permalinks['query_base'] ); ?>"
					placeholder="<?php echo _x('catalog', 'slug','wp-woo-psr') ?>" />
				<span>
					<?php printf( _x( 'results in %s where %s will be substituted with the slug of the Query', 'options-permalink', 'wp-woo-psr' ),
						"<code>/".(isset($permalinks['query_base'])?$permalinks['query_base']:_x('catalog','slug','wp-woo-psr'))."/%pagename%/%woo-psr-query%</code>",
						"<code>%woo-psr-query%</code>"
					); ?>
				</span>
			<?php
		}, 'permalink', 'wp-woo-psr-permalink');

		// save permalink options
		// NOTE: weird place for POST handling - but Woocommerce does it in admin_init too.
		if ( is_admin() && isset( $_POST['permalink_structure'] ) )//|| isset( $_POST['category_base'] ) && isset( $_POST['product_permalink'] ) ) {
		{
			$query_slug = wc_clean( $_POST['wp_woo_psr_query_slug'] );
			$permalinks = get_option( $this->option_name );
			if ( ! $permalinks ) $permalinks = array();
			$permalinks['query_base']  = untrailingslashit( $query_slug );
			update_option( $this->option_name, $permalinks );
		}
	}

	/**
	 * This method uses $_REQUEST and not $_POST because $_POST is used for individual edits,
	 * whereas $_GET is used for bulk edit.
	 */
	public function save( $post_id, $post )
	{
		#echo "<code><b>".__FILE__."</b> save($post_id,..)</code>";
		if ( ! isset( $_REQUEST['psr_meta_nonce'] )
			|| ! wp_verify_nonce( $_REQUEST['psr_meta_nonce'], plugin_basename($this->nonce_key) )
			|| ! current_user_can( 'edit_post', $post_id )	// already checked in wp_(update|insert)_post
		//|| $post->post_type == 'revision'
		)
		{
			/*
			#echo
			$this->plugin->notice( "abort saving query: "
				. ( current_user_can( 'edit_post', $post_id )? "" : "no edit_post permission; " )
				. ( $post->post_type == 'revision' ? " is revision; " : "" )
				. ( wp_verify_nonce( $_REQUEST['psr_meta_nonce'], plugin_basename(__FILE__) ) ? ""
					: " nonce mismatch: got ".$_REQUEST['psr_meta_nonce']."; expected ". wp_create_nonce( $this->nonce_key )
					.";" )
			);
			*/
			return;
		}

		if ( ! is_a( $post, 'WP_Post' ) || $post->ID != $post_id )
			$post = get_post($post_id);

		// store woocommerce attributes:
		if ( isset( $_REQUEST['attribute_names'] ) )
		foreach ( $_REQUEST['attribute_names'] as $i => $taxname )
		{
			$values = isset( $_REQUEST['attribute_values'][$i] ) ? $values = $_REQUEST['attribute_values'][$i] : array();
		#	echo $this->plugin->notice( "$post_id, attribute $taxname = ".implode("|", $values ) ."<br><b>save result:</b>".
		#	"");
			#print_r(
			wp_set_object_terms( $post_id, $values, $taxname, false )
			#,true))
			;
		}

		$resultpage_override = isset( $_REQUEST['_psr_override_resultpage'] );
		if ( $post->post_parent )
			update_post_meta( $post_id, '_psr_override_resultpage', $resultpage_override );	// don't update unless parent
		else
			$resultpage_override = false;

		$resultpage_id = isset( $_REQUEST['_psr_resultpage'] ) ? $_REQUEST['_psr_resultpage'] : null;
		// resultpage values:
		// -1		: no change
		// null	: not set
		// "",0	: none
		// > 1	: page

		if ( $post->post_parent && !$resultpage_override && !isset($_REQUEST['bulk_edit']))
			$resultpage_id = get_post_meta( $post->post_parent, '_psr_resultpage', true );

		$notice_extra="";	// optional extra notice text pertaining to updated child queries
		if ( $resultpage_id !== null && $resultpage_id != -1 ) // -1: no change; only appliccable in bulk edit
		{
			// verify
			if ( $resultpage_id )
			{
				$resultpage=get_post( $resultpage_id );
				if ( !psr_is_resultpage( $resultpage ) )
					$this->plugin->error( "Not resultpage: '$resultpage_id' (missing marker). $resultpage->post_type - $resultpage->post_name - $resultpage->ID" );
			}

			#$this->plugin->notice("set resultpage to $resultpage_id" );

			// keep this - always store a resultpage_id (the UPDATE below will not insert)
			#echo "update postmeta _psr_resultpage=$resultpage_id for $post_id: ".
			update_post_meta( $post_id, '_psr_resultpage', $resultpage_id );

			if ( isset( $_REQUEST['apply_psr_resultpage_recursive'] )
				&& $post->post_type != 'revision'
			)
			{
				$children = $this->get_descendants( $post_id );
				$this->plugin->notice( "<pre><b>descendants</b>\n".print_r($children,1)."</pre>" );
				if ( count( $children ) )
				{
					global $wpdb;
					$q = $wpdb->prepare(
						"
						UPDATE $wpdb->postmeta u
						LEFT JOIN $wpdb->postmeta k
						ON k.post_id = u.post_id AND k.meta_key='_psr_override_resultpage'
						SET u.meta_value=%s
						WHERE u.post_id IN (".implode( ",", $children).")
						AND u.meta_key='_psr_resultpage'
						AND (k.meta_value IS NULL || k.meta_value <> 1 )
						",
						$resultpage_id
					);

					$wpdb->query( $q );
					$notice_extra = "; " . sprintf(
						_x( "updated %d of %d child queries", 'posttype-save-msg', 'wp-woo-psr' ),
							$wpdb->rows_affected, count($children)
					);#<pre>".print_r($children,true)."</pre>";
				}
			}
		}
		#echo
		$this->plugin->notice( _x( "Saved query", 'posttype-save-msg', 'wp-woo-psr' ) . $notice_extra );
	}

	public function queries_page() {
		echo "<code>METHOD <b>queries_page</b> HANDLING!! ".print_r(func_get_args(),true)."</code>";
	}
}

