METAFILE=composer.json
ARTIFACT_FQNAME=$(shell php -r 'echo json_decode(file_get_contents("$(METAFILE)"))->name;')
ARTIFACT_NAME=$(shell echo $(ARTIFACT_FQNAME) | perl -ne 'chomp; s@.*?/@@; print')
ARTIFACT_VERSION=$(shell php -r 'echo json_decode(file_get_contents("$(METAFILE)"))->version;')
include $(dir $(abspath $(lastword $(MAKEFILE_LIST))))/Rules.mk

foo:
	echo $(ARTIFACT_NAME)

verify: common-verify
ifndef DEPLOY_BASE
	$(error DEPLOY_BASE is not set.)
endif

ident: verify
	@echo "###################################################"
	@echo "# Building      $(ARTIFACT_FQNAME) $(ARTIFACT_VERSION)"
	@echo "# last updated: $(LAST_UPDATED)"
	@echo "# deploy base:  $(DEPLOY_BASE)"
	@echo "###################################################"
	@echo


package: verify common-package-prepare prepare-package
	@cd dist/$(ARTIFACT_NAME) && zip -rq ../$(ARTIFACT_NAME)-$(ARTIFACT_VERSION).zip .
	@echo "Built package dist/$(ARTIFACT_NAME)-$(ARTIFACT_VERSION).zip"
