# USE
# ---
#
# Do not include this file directly, but instead include one of:
# Rules-composer.mk  or
# Rules-wp.mk.
#
# CONFIGURATION
# -------------
#
# Before including this file, please set:
#
#	ARTIFACT_MAINFILE
# 		style.css for themes or plugin.php for plugins;
#
#	DEPLOY_BASE
#		local path to wp-plugins or wp-themes repository directory
#
# These settings are automatically initialized but can be overridden:
#
#	ARTIFACT_NAME
#		This will be used througout. It defaults to the basename
#		of the project directory.
#
#	ARTIFACT_CHANGELOG
#		the file from which to extract changelog information.
#		defaults to $(ARTIFACT_MAINFILE).
#		When not a .txt file, the ARTIFACT_CHANGELOG file
#		is expected to have a "* Changelog:\n" line.
#		See build.pl.

SHELL=/bin/bash

# Verify the required settings exist:
common-verify:
ifndef DEPLOY_BASE
	$(error DEPLOY_BASE is undefined; set to '../path/to/repo/')
endif

# Initialize derived (but overridable) settings:
ifndef ARTIFACT_NAME
ARTIFACT_NAME=$(shell echo $(PWD) | sed -e "s@`dirname $(PWD)`/@@")
endif

ifdef ARTIFACT_MAINFILE
ifndef ARTIFACT_CHANGELOG
ARTIFACT_CHANGELOG = $(ARTIFACT_MAINFILE)
endif
endif

# Extract data:
#ARTIFACT_VERSION=$(shell grep 'Version:' $(ARTIFACT_MAINFILE) | cut -f2 -d' ' )
#CHANGELOG=$(shell build.pl $(ARTIFACT_CHANGELOG) extract-changelog)
LAST_UPDATED=$(shell perl -e 'use POSIX qw(strftime); @a=stat("."); print strftime( "%Y-%m-%d %H:%M:%S %Z",  localtime $$a[9])')

DEPLOY_FILES+=dist/$(ARTIFACT_NAME)-$(ARTIFACT_VERSION).zip

#########
# Rules:

common-package-prepare: verify
	@rm -rf dist/
	@mkdir dist/
	@mkdir dist/$(ARTIFACT_NAME)
	

deploy: verify package overwrite_check deploy-copy

force-deploy: verify package deploy-copy



# Utility rules:

overwrite_check: verify 
	@[ ! -f $(DEPLOY_BASE)/$(ARTIFACT_NAME)/$(ARTIFACT_NAME)-$(ARTIFACT_VERSION).zip ] || \
	( echo "$(ARTIFACT_NAME) version $(ARTIFACT_VERSION) already deployed. Use target force-deploy to overwrite" && false )
	@#TODO: make backup

deploy-copy: verify
	@echo "Deploying $(ARTIFACT_NAME)-$(ARTIFACT_VERSION) to $(DEPLOY_BASE)/$(ARTIFACT_NAME)"
	@[ -d $(DEPLOY_BASE)/$(ARTIFACT_NAME) ] || mkdir $(DEPLOY_BASE)/$(ARTIFACT_NAME)
	@[ -f $(DEPLOY_BASE)/$(ARTIFACT_NAME)/index.json ] && \
		mv $(DEPLOY_BASE)/$(ARTIFACT_NAME)/index.json $(DEPLOY_BASE)/$(ARTIFACT_NAME)/index.json.old || true
	@cp $(DEPLOY_FILES) $(DEPLOY_BASE)/$(ARTIFACT_NAME)/
