<?php

/**
 * Private use: (option value manipulation)
 *  use $this->_get_option('option_name') to get the actual option value;
 *
 * Public use: 
 *  use $this->option_name to get a postprocessed version; for instance,
 *  the product_images_dir option returns the path relative to the uploads
 *  dir in the first case, and the full path in the second case.
 */
class PluginOptions
{
	private $_options;	# pure hash of key=>value, no option meta
	private $_changed = false;

	private $_optname;

	public function __construct( $plugin, $option_name )
	{
		$this->_optname = $option_name;
		#add_action( 'admin_enqueue_scripts', function() use ($plugin) {
		#	$plugin->add_style( 'options' );
		#} );

#		if ( is_admin() )
#			add_action( 'admin_init', array( $this, 'settings_register' ) );

#$this->_init_options(); // temprary
	}

	private function _init_options()
	{
		if ( $this->_options == null )
		{
			#echo "<code style='background-color:blue;color:white'>INIT OPTIONS</code>".$this->_caller();

			$opts = maybe_unserialize( get_option( $this->_optname ) );
			#echo "<pre><b>retrieved:</b> ".print_r($opts,true)."</pre>";

			$this->_options = array();
			foreach ( $this->_get_default_options() as $k=>$v )
			{
				#echo "<code>DEBUG: $k => ".($opts===false?"FALSE":"OK").' '.(isset($opts[$k])?"isset":"NOT SET")
				#	.' v='.print_r($v['v'],1)." o=".print_r($opts[$k],1)
				#	."</code><br/>";
				#	;//.' '.print_r($v,1)
				$this->_options[$k] =
					$opts === false || !isset( $opts[$k] )
					? $v['v']
					: $opts[$k];
			}

			if ( $opts === false )
				add_option( $this->_optname, $this->_options );
			else
				update_option( $this->_optname, maybe_serialize( $this->_options ) );

			#echo "<code>initialized options: " . maybe_serialize($this->_options).";<br>opts=".($opts?print_r($opts,1):"false")."</code><br>";
		}
	}

	/**
	 * Override this to configure the options.
	 */
	protected function _get_default_options()
	{
		return array(
			/*
			'name'	=> array(
				't' => type: bool | dir | lang | currency | enum | radio | number
				'i' => input@type: checkbox | text,
				'v' => default-value,  // make this an empty array() to have the option be a list/hash.
				'V' => array( value => label ), // for enum/radio/select (select: TODO)
				'l' => label,
				'd' => description,
				'g' => function getter($key)
				'c' => function post_render_row( $k, $v, $actual_value )
				)
			)
			*/

			'menu_location'	=> array(
															't' => 'enum',
															'i' => 'radio',
															'v' => 'options-general.php',
															'V' => array(
																			// use default wp translation
																			'index.php						'	=> __('Dashboard'),
																			'options-general.php'		=> __('Settings'),
																			'plugins.php'						=> __('Plugins'),
																	),
															'l' => _x('Menu Location', 'options', 'custom-plugin-updater'),
															'd' => _x('Where to place the link to the Options. It is also available as an action link in the Plugin list page.', 'options', 'custom-plugin-updater'),
													),

			'transient_timeout'	=> array(
															't' => 'number',
															'i' => 'number',
															'v' => 3600,
															'V' => array( 'min' => 60, 'max' => null ),
															'l' => _x('Transient Timeout', 'options', 'custom-plugin-updater'),
															'd' => _x('The minimum time in seconds between checking for plugin/theme updates', 'options', 'custom-plugin-updater'),
													),

		);
	}

  private static function _caller() {
    $s = debug_backtrace();
    $stack = "";
    foreach ( $s as $i=>$r )
      $stack .= "&nbsp;&nbsp;".(isset($r['file'])?$r['file']:'?') . "[" . (isset($r['line'])?$r['line']:'?') . "](".(isset($r['class'])?$r['class'].'.':'').$r['function'].")" . "<br/>";
    return "<br/><pre>$stack</pre>";
  }


	public function __get( $name ) {
		$this->_init_options();

		$mname='get_'.$name;
		if ( method_exists( get_class(), $mname ) )
			return $this->$mname();

		return $this->_get_option( $name );
	}

	public function __isset( $name ) {
		$this->_init_options();
		return $name == 'options' ? true : isset( $this->_options[ $name ] );
	}

	private function _get_option( $name ) {
		$this->_init_options();

		#echo "<code style='background-color:blue;color:white'>GET OPTION $name</code>".$this->_caller();

		if ( $name == 'options' )	# special case
			return $this->_options;

		if ( isset( $this->_options[ $name ] ) )
			return $this->_options[ $name ]; #XXX;
		else
		{
			echo "<div class='error'>Mercator: unknown option '$name' (".print_r($this->_options[$name],1).")</div>";
			return false;
		}
	}

	private function get_product_image_dir() {
		return wp_upload_dir()['basedir'].'/'.$this->get_product_image_rel_dir();
	}

	private function get_product_image_rel_dir() {
		return ltrim( rtrim( $this->_get_option( 'product_image_dir' ), '/') ,'/' );
	}

	public function __set( $name, $value ) {
		$this->_init_options();

		#echo "<code style='background-color:blue;color:red'>SET OPTION $name</code>".$this->_caller();

		$this->_options[ $name ] = $value;
		$this->_changed=true;
		update_option( $this->_optname, maybe_serialize( $this->_options ) );
	}



////////////////////////////////////////////////
	/////// settings (_admin_menu_options)
	public function page()
	{
		?>
<style type='text/css'>
.removed  { /*border: .5px dashed red;*/
	color: #aaa; text-decoration: line-through; }
.removed th label {
	color: #aaa;
}
.removed td:nth-child(2) input {
	background-color: #ddd;
	color: white;
}
.removed td input[type='button'] {
	background-color: inherit;
	color: inherit;
}
</style>

		<?php
		# the options.php from wp doesn't work; too complex. may only work with
		# one value per option.
		if ( isset( $_POST['action'] ) && $_POST['action'] == 'update' )
		{
			foreach ( $this->options as $k=>$v )
			{
				if ( $this->_get_default_options()[$k]['i'] == 'checkbox' )
					$this->$k = isset($_POST[$k]);
				else if ( isset( $_POST[$k] ) )
				{
					if ( is_array( $_POST[$k] ) )
					{
						$this->$k = array_filter(
							array_map( 'sanitize_text_field', $_POST[$k] ),
							function($v){return $v;}
						);
					}
					else
						$this->$k = sanitize_text_field( $_POST[$k] );
				}
				else
					echo "<div class='error'>missing setting $k ({$_POST[$k]})</div>";

				echo "<div class='updated'>Updated: '$k' => ".print_r($this->$k,true)."</div>";
			}

			echo "<div class='updated'>".__('Settings saved')."</div>";
		}

		?>
		<h2><?php _ex('Options', 'options-h', 'wp-woo-psr');?></h2>

		<script type="text/javascript">
			function mc_reset_option( id, def ) {
				var el = document.getElementById( id );
				//alert( "Reset " + id  + " (" + el.type + ")" + " to " + def );
				switch( el.type )
				{
					case 'checkbox':
					case 'radio':
						el.checked = def;
						break;
					default:
						el.value = def;
				}
			}
		</script>

		<form method='post'><!-- it doesn't work... action="options.php">-->
		<?php
		//	$this->settings_fields( $this->_optname );#'psr-settings-group' );
			$this->do_settings_sections( 'psr-admin-options' );
			$this->submit_button();
		?>
		</form>
		<?php
	}

	//// These are purely for the backend!
	public function settings_register() {
		$this->register_setting( $this->_optname/*'psr-settings-group'*/, $this->_optname,
#			function($input) {
#				echo "<code>SANITIZE</code>";
#				foreach ( $input as $k=>$v )
#					$input[$k] = sanitize_text_field( $v );
#				return $input;
#			}
			array($this,'settings_validate')
		);

		$this->add_settings_section(
			'psr-setting-section-1',
			_x('Custom Settings', 'options', 'wp-woo-psr'),
			function(){echo "Edit MC Settings";},
			'psr-admin-options'
		);

		foreach ( $this->_get_default_options() as $k=>$v )
		{
			#echo "<code>$k=>".print_r($v,true)."</code><br/>";
			$this->add_settings_field( $k, $v['l'], function() use($k,$v)
			{
				?>
				<table style='width:100%'>
					<tr>
						<td>FOO doesn't do anything???</td>
						<td>
						{
							<?php $resetbutton = $this->_render_field( $k, $v ); //outputs also ?>
						}
						</td>
						<td style='width:10%'><?php echo $resetbutton; ?>BTN</td>
					</tr>
				</table>
				<?php
			},
			'psr-admin-options', 'psr-setting-section-1'#,arg-passed-to-closure
			);
		}
	}



	private function _render_field( $k, $v, $value = null, $index = null )
	{
		if ( $value === null ) $value = $this->_get_option($k);

		$islist = is_array( $this->_get_default_options()[$k]['v'] );
		if ( $islist && !is_int( $index ) ) // $index == null )
			echo "<code>warn: list option value but no index!</code>";

		$id = 'id_'.$k;
		$name = $k;

		switch ( $v['t'] )
		{
			case 'bool':
				printf( '<input id="id_%s" type="checkbox" name="%s" value="1" %s/>',
					$k, $k, $value ? "checked" : ""
				);
				break;

			case 'enum':
			case 'radio':
				{
					$def = null;
					foreach ( $this->_get_default_options()[$k]['V'] as $val => $l )
					{
						$id = 'id_'.$k.'_'.$val;
						if ( $val === $v['v'] )
							$def = $id;
						printf(
						'<input id="%s" type="radio" name="%s" value="%s" %s/>'.
						'<label for="%s">%s</label><br/>',
							$id, $k, $val, $value === $val || $def === $id ? 'checked' : '',
							$id, $l
						);
					}
					return
						"<input type='button' class='button' value='Reset' onclick='mc_reset_option(\"$def\", \"".
						$this->_get_default_options()[$k]['v']
						."\");'/>";
				}

			case 'number':
				printf('<input id="id_%s" name="%s" type="number" min="%s" max="%s" value="%s"/>',
					$k, $k, $v['V']['min'], $v['V']['max'], $value
				);
				break;

			case 'text':
			case 'dir':
			case 'file':
			default:
			{
				$id = 'id_'.$k;
				$name = $k;

				if ( $islist )
				{
					$name .= '['.$index.']';
					$id .= '_'.$index;
				}
				printf('<input id="%s" type="text" size="60" name="%s" value="%s"/>',
					$id, $name, esc_attr( is_array( $value ) && count($value)==0 ? '' : $value )
				);
				# TODO: escape value (")
				break;
			}
		}

		$tmp = isset($v['button'])?$v['button']:null;
		return is_array( $this->_get_default_options()[$k]['v'] )
			? (
					isset( $v['button'] )
					? $v['button']($id, $name)
					: '(no button)'
			  )

			:
			"<input type='button' class='button' value='Reset' onclick='mc_reset_option(\"id_$k\", \"".
			$this->_get_default_options()[$k]['v']
			."\");'/>";
	}

	public function settings_validate( $input ) {
		echo "<code>SANITIZE: ".print_r(func_get_args(),true)."</code>";return $input;
	}


	private function register_setting( $group, $option_name, $callback ) {
		if ( 0 ) return register_setting( $group, $option_name, $callback );
	}

	private function add_settings_section( $section, $title, $callback, $page ) {
		if ( 0 ) return add_settings_section( $section, $title, $callback, $page );
	}

	private function add_settings_field( $fieldname, $label, $callback, $group_or_option_name, $section ) {
		if ( 0 ) return add_settings_field( $fieldname, $label, $callback, $group_or_option_name, $section );
	}


	private function settings_fields( $group )
	{
		if ( 0 ) return settings_fields( $group );
	}

	private function do_settings_sections( $page ) 
	{
		if ( 0 ) return do_settings_sections( $page );

		?>
		<input type='hidden' name='action' value='update'/>
		<style type="text/css">
			table.form-table.wp-plugin-base-options td { vertical-align: top; }
		</style>
		<table class='form-table wp-plugin-base-options'>
		<?php
		foreach ( $this->_get_default_options() as $k=>$v )
		{
			$do = $this->_get_default_options()[$k];

			if ( is_array( $do['v'] ) )
			{
				#echo "<tr><th><i>list-option</i></th></tr>";
				$va = $this->_get_option($k);
				$va = is_array( $va ) ? $va : array( $va );

				$x = $v;
				$x['button']=function($id, $name) {
					return <<<HTML
					<input type='hidden' name="remove_{$name}" value='false'/>
					<input type='button' value='Remove' data='remove' class='button' onclick="
						if ( this.attributes['data'].value == 'remove' )
						{
							this.value='Reset';
							this.attributes['data'].value='add';
							jQuery(this).closest( 'tr' ).addClass('removed');
							jQuery( '#remove_{$name}' ).val('true');
						}
						else
						{
							this.value='Remove';
							this.attributes['data'].value='remove';
							jQuery(this).closest( 'tr' ).removeClass('removed');
							jQuery( '#remove_{$name}' ).val('false');
						}
						console.log(this)
					">
HTML;
				};

				foreach ( $va as $i => $vv )
					$this->_render_row( $k, $x, $vv, $i );

				$x['button']=function($id,$name){return '';};
				$this->_render_row( $k, $x, '', count($va) );
			}
			else
			$this->_render_row( $k, $v );
		}
		echo "</table>";
	}

	private function _render_row( $k, $v, $vv = null, $index=null )
	{
		echo "<tr>";
		#echo "<td>V:<code>".print_r($v,true)."</code></td>";

		# XXX FIXME : we're not sure what id is used.
		$id = "id_$k"
			. ( $islist = is_array( $this->_get_default_options()[$k]['v'] ) ? '['.$index.']' : '' );
		echo "<th><label for='id_$k'>".$v['l'].($islist?" #".($index+1) : '')."</label></th><td>";
		$resetbutton=$this->_render_field($k,$v, $vv, $index );

		if ( isset( $v['c'] ) ) echo $v['c']( $k, $v, $vv );
		echo "</td><td>".(isset($v['d'])?$v['d']:"")."</td>";
		echo "<td>$resetbutton</td>";
		echo "</tr>";
	}

	private function submit_button()
	{
		if ( 1 ) return submit_button();
	}

}

?>
